#include <amxmodx>
#include <engine>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <cstrike>
#include <xs>
#include <zombieplague>

#define PLUGIN "[ZP] Extra Item: Needler"
#define VERSION "1.0"
#define AUTHOR "Dias"

#define V_MODEL "models/v_coilgun.mdl"
#define P_MODEL "models/p_coilgun.mdl"
#define W_MODEL "models/w_coilgun.mdl"

#define S_NAIL "models/s_coil.mdl"

#define CSW_COILGUN CSW_MP5NAVY
#define weapon_coilgun "weapon_mp5navy"

#define WEAPON_EVENT "events/mp5n.sc"
#define OLD_W_MODEL "models/w_mp5.mdl"
#define WEAPON_SECRETCODE 4965
#define NAIL_CLASSNAME "nail"

#define DAMAGE 116
#define CLIP 100
#define BPAMMO 200
#define SPEED 4.0
#define NAIL_SPEED 1000.0
#define DRAW_TIME 1.0
#define RELOAD_TIME 3.5

#define SMART_NAIL 1 // This is a new feature, added by Dias. If this SMART_NAIL is enabled, the nail will chase the nearest player

new const Weapon_Sounds[4][] =
{
	"weapons/coilgun-1.wav",
	"weapons/coilgun_clipin1.wav",
	"weapons/coilgun_clipin2.wav",
	"weapons/coilgun_clipout.wav"
}

new const Weapon_Resources[3][] =
{
	"sprites/weapon_coilgun.txt",
	"sprites/640hud3_3.spr",
	"sprites/640hud88_2.spr"
}

enum
{
	ANIM_IDLE = 0,
	ANIM_SHOOT1,
	ANIM_SHOOT2,
	ANIM_RELOAD,
	ANIM_DRAW
}

new g_coilgun
new g_had_coilgun[33], g_coilgun_clip[33], g_old_weapon[33]
new g_coilgun_event, g_trail_sprid, g_ham_bot, g_MaxPlayers

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_event("CurWeapon", "Event_CurWeapon", "be", "1=1")
	
	register_forward(FM_UpdateClientData, "fw_UpdateClientData_Post", 1)	
	register_forward(FM_PlaybackEvent, "fw_PlaybackEvent")	
	register_forward(FM_SetModel, "fw_SetModel")	
	register_forward(FM_Touch, "fw_Touch")
	
	RegisterHam(Ham_TraceAttack, "worldspawn", "fw_TraceAttack")
	RegisterHam(Ham_TraceAttack, "player", "fw_TraceAttack")	
	RegisterHam(Ham_Item_PostFrame, weapon_coilgun, "fw_Item_PostFrame")	
	RegisterHam(Ham_Weapon_Reload, weapon_coilgun, "fw_Weapon_Reload")
	RegisterHam(Ham_Weapon_Reload, weapon_coilgun, "fw_Weapon_Reload_Post", 1)	
	RegisterHam(Ham_Item_AddToPlayer, weapon_coilgun, "fw_Item_AddToPlayer_Post", 1)
	
	g_MaxPlayers = get_maxplayers()
	
	register_clcmd("admin_get_needler", "Get_CoilGun", ADMIN_KICK)
	register_clcmd("weapon_coilgun", "Hook_Weapon")
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheModel, V_MODEL)
	engfunc(EngFunc_PrecacheModel, P_MODEL)
	engfunc(EngFunc_PrecacheModel, W_MODEL)
	
	engfunc(EngFunc_PrecacheModel, S_NAIL)
	
	new i
	for(i = 0; i < sizeof(Weapon_Sounds); i++)
		engfunc(EngFunc_PrecacheSound, Weapon_Sounds[i])
	for(i = 0; i < sizeof(Weapon_Resources); i++)
	{
		if(i == 0) engfunc(EngFunc_PrecacheGeneric, Weapon_Resources[i])
		else engfunc(EngFunc_PrecacheModel, Weapon_Resources[i])
	}
	
	g_trail_sprid = engfunc(EngFunc_PrecacheModel, "sprites/laserbeam.spr")
	register_forward(FM_PrecacheEvent, "fw_PrecacheEvent_Post", 1)
	
	g_coilgun = zp_register_extra_item("Needler (Nail-Gun)", 20, ZP_TEAM_HUMAN)
}

public fw_PrecacheEvent_Post(type, const name[])
{
	if(equal(WEAPON_EVENT, name))
		g_coilgun_event = get_orig_retval()		
}

public zp_extra_item_selected(id, itemid)
{
	if(itemid == g_coilgun) Get_CoilGun(id)
}

public zp_user_infected_post(id) Remove_CoilGun(id)
public zp_user_humanized_post(id) Remove_CoilGun(id)

public Get_CoilGun(id)
{
	if(!is_user_alive(id))
		return
		
	g_had_coilgun[id] = 1
	fm_give_item(id, weapon_coilgun)
	
	static Ent; Ent = fm_get_user_weapon_entity(id, CSW_COILGUN)
	if(pev_valid(Ent)) cs_set_weapon_ammo(Ent, CLIP)
	
	cs_set_user_bpammo(id, CSW_COILGUN, BPAMMO)
	update_ammo(id, CSW_COILGUN, CLIP, BPAMMO)
}

public Remove_CoilGun(id)
{
	if(!is_user_connected(id))
		return
		
	g_had_coilgun[id] = 0
}

public Hook_Weapon(id)
{
	engclient_cmd(id, weapon_coilgun)
	return PLUGIN_HANDLED
}

public client_putinserver(id)
{
	if(!g_ham_bot && is_user_bot(id))
	{
		g_ham_bot = 1
		set_task(0.1, "Do_Register_HamBot", id)
	}
}

public Do_Register_HamBot(id)
{
	RegisterHamFromEntity(Ham_TraceAttack, id, "fw_TraceAttack")
}

public Event_CurWeapon(id)
{
	if(!is_user_alive(id))
		return
	
	if((get_user_weapon(id) == CSW_COILGUN && g_old_weapon[id] != CSW_COILGUN) && g_had_coilgun[id])
	{ 
		set_pev(id, pev_viewmodel2, V_MODEL)
		set_pev(id, pev_weaponmodel2, P_MODEL)
		
		set_weapon_anim(id, ANIM_DRAW)
		
		set_weapon_timeidle(id, CSW_COILGUN, DRAW_TIME)
		set_player_nextattack(id, DRAW_TIME)
	} else if((get_user_weapon(id) == CSW_COILGUN && g_old_weapon[id] == CSW_COILGUN) && g_had_coilgun[id]) {
		static Ent; Ent = fm_get_user_weapon_entity(id, CSW_COILGUN)
		if(pev_valid(Ent)) set_pdata_float(Ent, 46, get_pdata_float(Ent, 46, 4) * SPEED, 4)
	}
	
	g_old_weapon[id] = get_user_weapon(id)
}

public fw_UpdateClientData_Post(id, sendweapons, cd_handle)
{
	if(!is_user_alive(id) || !is_user_connected(id))
		return FMRES_IGNORED	
	if(get_user_weapon(id) == CSW_COILGUN && g_had_coilgun[id])
		set_cd(cd_handle, CD_flNextAttack, get_gametime() + 0.001) 
	
	return FMRES_HANDLED
}

public fw_PlaybackEvent(flags, invoker, eventid, Float:delay, Float:origin[3], Float:angles[3], Float:fparam1, Float:fparam2, iParam1, iParam2, bParam1, bParam2)
{
	if (!is_user_connected(invoker))
		return FMRES_IGNORED	
	if(get_user_weapon(invoker) != CSW_COILGUN || !g_had_coilgun[invoker])
		return FMRES_IGNORED
	
	if(eventid == g_coilgun_event)
	{
		engfunc(EngFunc_PlaybackEvent, flags | FEV_HOSTONLY, invoker, eventid, delay, origin, angles, fparam1, fparam2, iParam1, iParam2, bParam1, bParam2)
		
		set_weapon_anim(invoker, random_num(ANIM_SHOOT1, ANIM_SHOOT1))
		emit_sound(invoker, CHAN_WEAPON, Weapon_Sounds[0], 1.0, ATTN_NORM, 0, PITCH_NORM)

		return FMRES_SUPERCEDE
	} 
	
	return FMRES_HANDLED
}

public fw_SetModel(entity, model[])
{
	if(!pev_valid(entity))
		return FMRES_IGNORED
	
	static Classname[32]
	pev(entity, pev_classname, Classname, sizeof(Classname))
	
	if(!equal(Classname, "weaponbox"))
		return FMRES_IGNORED
	
	static iOwner
	iOwner = pev(entity, pev_owner)
	
	if(equal(model, OLD_W_MODEL))
	{
		static weapon; weapon = fm_find_ent_by_owner(-1, weapon_coilgun, entity)
		
		if(!pev_valid(weapon))
			return FMRES_IGNORED;
		
		if(g_had_coilgun[iOwner])
		{
			g_had_coilgun[iOwner] = 0
			
			set_pev(weapon, pev_impulse, WEAPON_SECRETCODE)
			engfunc(EngFunc_SetModel, entity, W_MODEL)
			
			return FMRES_SUPERCEDE
		}
	}

	return FMRES_IGNORED;
}

public fw_Touch(Ent, Id)
{
	if(!pev_valid(Ent))
		return
		
	static Classname[32]; pev(Ent, pev_classname, Classname, sizeof(Classname))
	if(!equal(Classname, NAIL_CLASSNAME))
		return
		
	static ptr; ptr = pev(Ent, pev_iuser4)
	static Owner; Owner = pev(Ent, pev_owner)
		
	if(!is_user_connected(Owner))
	{
		engfunc(EngFunc_RemoveEntity, Ent)
		free_tr2(ptr)
		
		return
	}
		
	if(pev_valid(Id))
	{
		static EntGun; EntGun = fm_get_user_weapon_entity(Owner, CSW_COILGUN)
		
		do_attack(Owner, Id, EntGun, float(DAMAGE))
		engfunc(EngFunc_RemoveEntity, Ent)
	} else {
		if(pev(Ent, pev_iuser3))
		{
			static Float:Origin[3], Float:Angles[3], Float:Origin2[3], Float:NewVelocity[3]
			static Smart_Nail; Smart_Nail = SMART_NAIL
			
			if(random_num(0, 1)) Smart_Nail = 0
			
			pev(Ent, pev_origin, Origin)
			
			if(!Smart_Nail) pev(Owner, pev_origin, Origin2)
			else {
				static Enemy; Enemy = FindClosetEnemy(Ent, 1)
				if(is_user_alive(Enemy)) pev(Enemy, pev_origin, Origin2)
				else  {
					pev(Owner, pev_origin, Origin2)
					Smart_Nail = 0
				}
			}
			
			pev(Ent, pev_angles, Angles)
			
			get_speed_vector(Origin, Origin2, NAIL_SPEED, NewVelocity)

			if(!Smart_Nail)
			{
				NewVelocity[0] += random_float(-500.0, 500.0)
				NewVelocity[1] += random_float(-500.0, 500.0)
				NewVelocity[2] += random_float(-500.0, 500.0)
			}
			
			Create_Nail(Owner, 0, Origin, Angles, Origin2, NewVelocity)
			
			set_pev(Ent, pev_iuser3, 0)
			engfunc(EngFunc_RemoveEntity, Ent)
		} else {
			engfunc(EngFunc_RemoveEntity, Ent)
		}
	}
	
	free_tr2(ptr)
}

public fw_TraceAttack(ent, attacker, Float:Damage, Float:fDir[3], ptr, iDamageType)
{
	if(!is_user_alive(attacker))
		return HAM_IGNORED	
	if(get_user_weapon(attacker) != CSW_COILGUN || !g_had_coilgun[attacker])
		return HAM_IGNORED
		
	Handle_Nail(attacker)
	
	return HAM_SUPERCEDE
}

public fw_Item_PostFrame(ent)
{
	static id; id = pev(ent, pev_owner)
	if(!is_user_alive(id))
		return HAM_IGNORED
	if(!g_had_coilgun[id])
		return HAM_IGNORED	
	
	static Float:flNextAttack; flNextAttack = get_pdata_float(id, 83, 5)
	static bpammo; bpammo = cs_get_user_bpammo(id, CSW_COILGUN)
	
	static iClip; iClip = get_pdata_int(ent, 51, 4)
	static fInReload; fInReload = get_pdata_int(ent, 54, 4)
	
	if(fInReload && flNextAttack <= 0.0)
	{
		static temp1
		temp1 = min(CLIP - iClip, bpammo)

		set_pdata_int(ent, 51, iClip + temp1, 4)
		cs_set_user_bpammo(id, CSW_COILGUN, bpammo - temp1)		
		
		set_pdata_int(ent, 54, 0, 4)
		
		fInReload = 0
	}		
	
	return HAM_IGNORED
}

public fw_Weapon_Reload(ent)
{
	static id; id = pev(ent, pev_owner)
	if(!is_user_alive(id))
		return HAM_IGNORED
	if(!g_had_coilgun[id])
		return HAM_IGNORED

	g_coilgun_clip[id] = -1
		
	static BPAmmo; BPAmmo = cs_get_user_bpammo(id, CSW_COILGUN)
	static iClip; iClip = get_pdata_int(ent, 51, 4)
		
	if(BPAmmo <= 0)
		return HAM_SUPERCEDE
	if(iClip >= CLIP)
		return HAM_SUPERCEDE		
			
	g_coilgun_clip[id] = iClip	
	
	return HAM_HANDLED
}

public fw_Weapon_Reload_Post(ent)
{
	static id; id = pev(ent, pev_owner)
	if(!is_user_alive(id))
		return HAM_IGNORED
	if(!g_had_coilgun[id])
		return HAM_IGNORED
		
	if((get_pdata_int(ent, 54, 4) == 1))
	{ // Reload
		if(g_coilgun_clip[id] == -1)
			return HAM_IGNORED
		
		set_pdata_int(ent, 51, g_coilgun_clip[id], 4)
		
		set_weapon_anim(id, ANIM_RELOAD)
		
		set_weapon_timeidle(id, CSW_COILGUN, RELOAD_TIME)
		set_player_nextattack(id, RELOAD_TIME)
	}
	
	return HAM_HANDLED
}

public fw_Item_AddToPlayer_Post(ent, id)
{
	if(!pev_valid(ent))
		return HAM_IGNORED
		
	if(pev(ent, pev_impulse) == WEAPON_SECRETCODE)
	{
		g_had_coilgun[id] = 1
		set_pev(ent, pev_impulse, 0)
	}	
	
	message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("WeaponList"), .player = id)
	write_string(g_had_coilgun[id] == 1 ? "weapon_coilgun" : "weapon_mp5navy")
	write_byte(10) // PrimaryAmmoID
	write_byte(200) // PrimaryAmmoMaxAmount
	write_byte(-1) // SecondaryAmmoID
	write_byte(-1) // SecondaryAmmoMaxAmount
	write_byte(0) // SlotID (0...N)
	write_byte(7) // NumberInSlot (1...N)
	write_byte(g_had_coilgun[id] == 1 ? CSW_COILGUN : CSW_MP5NAVY) // WeaponID
	write_byte(0) // Flags
	message_end()	

	return HAM_HANDLED	
}

public Handle_Nail(id)
{
	static Float:StartOrigin[3], Float:Angles[3], Float:EndOrigin[3], Float:Velocity[3]
	
	get_position(id, 30.0, 12.5, -10.0, StartOrigin)
	pev(id, pev_angles, Angles)
	
	fm_get_aim_origin(id, EndOrigin)
	get_speed_vector(StartOrigin, EndOrigin, NAIL_SPEED, Velocity)
	
	Create_Nail(id, 1, StartOrigin, Angles, EndOrigin, Velocity)
}

public Create_Nail(id, Reflect, Float:StartOrigin[3], Float:Angles[3], Float:EndOrigin[3], Float:Velocity[3])
{
	static Nail; Nail = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
	if(!pev_valid(Nail)) return
	
	set_pev(Nail, pev_movetype, MOVETYPE_FLY)
	set_pev(Nail, pev_solid, SOLID_BBOX)

	set_pev(Nail, pev_classname, NAIL_CLASSNAME)
	engfunc(EngFunc_SetModel, Nail, S_NAIL)
	set_pev(Nail, pev_origin, StartOrigin)
	set_pev(Nail, pev_angles, Angles)
	set_pev(Nail, pev_v_angle, Angles)
	
	set_pev(Nail, pev_owner, id)
	set_pev(Nail, pev_velocity, Velocity)
	
	// Make a Beam
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BEAMFOLLOW)
	write_short(Nail) // entity
	write_short(g_trail_sprid) // sprite
	write_byte(2)  // life
	write_byte(1)  // width
	write_byte(210) // r
	write_byte(210);  // g
	write_byte(210);  // b
	write_byte(150); // brightness
	message_end();	
	
	// Handle Trace Config
	static ptr; ptr = create_tr2() 
	engfunc(EngFunc_TraceLine, StartOrigin, EndOrigin, id, id, ptr)

	set_pev(Nail, pev_iuser4, ptr)
	set_pev(Nail, pev_iuser3, Reflect)
}

public update_ammo(id, CSWID, ammo, bpammo)
{
	if(!is_user_alive(id))
		return
	
	engfunc(EngFunc_MessageBegin, MSG_ONE_UNRELIABLE, get_user_msgid("CurWeapon"), {0, 0, 0}, id)
	write_byte(1)
	write_byte(CSWID)
	write_byte(ammo)
	message_end()
	
	message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("AmmoX"), _, id)
	write_byte(1)
	write_byte(bpammo)
	message_end()
}

stock set_weapon_timeidle(id, CSWID, Float:TimeIdle)
{
	if(!is_user_alive(id))
		return
		
	static entwpn; entwpn = fm_get_user_weapon_entity(id, CSWID)
	if(!pev_valid(entwpn)) 
		return
	
	set_pdata_float(entwpn, 46, TimeIdle, 4)
	set_pdata_float(entwpn, 47, TimeIdle, 4)
	set_pdata_float(entwpn, 48, TimeIdle + 1.0, 4)
}

stock set_player_nextattack(id, Float:nexttime)
{
	if(!is_user_alive(id))
		return
		
	set_pdata_float(id, 83, nexttime, 5)
}

stock set_weapon_anim(id, anim)
{
	if(!is_user_alive(id))
		return
	
	set_pev(id, pev_weaponanim, anim)
	
	message_begin(MSG_ONE_UNRELIABLE, SVC_WEAPONANIM, {0, 0, 0}, id)
	write_byte(anim)
	write_byte(pev(id, pev_body))
	message_end()
}

stock get_position(ent, Float:forw, Float:right, Float:up, Float:vStart[])
{
	static Float:vOrigin[3], Float:vAngle[3], Float:vForward[3], Float:vRight[3], Float:vUp[3]
	
	pev(ent, pev_origin, vOrigin)
	pev(ent, pev_view_ofs,vUp) //for player
	xs_vec_add(vOrigin,vUp,vOrigin)
	pev(ent, pev_v_angle, vAngle) // if normal entity ,use pev_angles
	
	angle_vector(vAngle,ANGLEVECTOR_FORWARD,vForward) //or use EngFunc_AngleVectors
	angle_vector(vAngle,ANGLEVECTOR_RIGHT,vRight)
	angle_vector(vAngle,ANGLEVECTOR_UP,vUp)
	
	vStart[0] = vOrigin[0] + vForward[0] * forw + vRight[0] * right + vUp[0] * up
	vStart[1] = vOrigin[1] + vForward[1] * forw + vRight[1] * right + vUp[1] * up
	vStart[2] = vOrigin[2] + vForward[2] * forw + vRight[2] * right + vUp[2] * up
}

stock get_speed_vector(const Float:origin1[3],const Float:origin2[3],Float:speed, Float:new_velocity[3])
{
	new_velocity[0] = origin2[0] - origin1[0]
	new_velocity[1] = origin2[1] - origin1[1]
	new_velocity[2] = origin2[2] - origin1[2]
	static Float:num; num = floatsqroot(speed*speed / (new_velocity[0]*new_velocity[0] + new_velocity[1]*new_velocity[1] + new_velocity[2]*new_velocity[2]))
	new_velocity[0] *= num
	new_velocity[1] *= num
	new_velocity[2] *= num
	
	return 1;
}

do_attack(Attacker, Victim, Inflictor, Float:fDamage)
{
	fake_player_trace_attack(Attacker, Victim, fDamage)
	fake_take_damage(Attacker, Victim, fDamage, Inflictor)
}

fake_player_trace_attack(iAttacker, iVictim, &Float:fDamage)
{
	// get fDirection
	static Float:fAngles[3], Float:fDirection[3]
	pev(iAttacker, pev_angles, fAngles)
	angle_vector(fAngles, ANGLEVECTOR_FORWARD, fDirection)
	
	// get fStart
	static Float:fStart[3], Float:fViewOfs[3]
	pev(iAttacker, pev_origin, fStart)
	pev(iAttacker, pev_view_ofs, fViewOfs)
	xs_vec_add(fViewOfs, fStart, fStart)
	
	// get aimOrigin
	static iAimOrigin[3], Float:fAimOrigin[3]
	get_user_origin(iAttacker, iAimOrigin, 3)
	IVecFVec(iAimOrigin, fAimOrigin)
	
	// TraceLine from fStart to AimOrigin
	static ptr; ptr = create_tr2() 
	engfunc(EngFunc_TraceLine, fStart, fAimOrigin, DONT_IGNORE_MONSTERS, iAttacker, ptr)
	static pHit; pHit = get_tr2(ptr, TR_pHit)
	static iHitgroup; iHitgroup = get_tr2(ptr, TR_iHitgroup)
	static Float:fEndPos[3]; get_tr2(ptr, TR_vecEndPos, fEndPos)

	// get target & body at aiming
	static iTarget, iBody
	get_user_aiming(iAttacker, iTarget, iBody)
	
	// if aiming find target is iVictim then update iHitgroup
	if (iTarget == iVictim)
	{
		iHitgroup = iBody
	}
	
	// if ptr find target not is iVictim
	else if (pHit != iVictim)
	{
		// get AimOrigin in iVictim
		static Float:fVicOrigin[3], Float:fVicViewOfs[3], Float:fAimInVictim[3]
		pev(iVictim, pev_origin, fVicOrigin)
		pev(iVictim, pev_view_ofs, fVicViewOfs) 
		xs_vec_add(fVicViewOfs, fVicOrigin, fAimInVictim)
		fAimInVictim[2] = fStart[2]
		fAimInVictim[2] += get_distance_f(fStart, fAimInVictim) * floattan( fAngles[0] * 2.0, degrees )
		
		// check aim in size of iVictim
		static iAngleToVictim; iAngleToVictim = get_angle_to_target(iAttacker, fVicOrigin)
		iAngleToVictim = abs(iAngleToVictim)
		static Float:fDis; fDis = 2.0 * get_distance_f(fStart, fAimInVictim) * floatsin( float(iAngleToVictim) * 0.5, degrees )
		static Float:fVicSize[3]
		pev(iVictim, pev_size , fVicSize)
		if ( fDis <= fVicSize[0] * 0.5 )
		{
			// TraceLine from fStart to aimOrigin in iVictim
			static ptr2; ptr2 = create_tr2() 
			engfunc(EngFunc_TraceLine, fStart, fAimInVictim, DONT_IGNORE_MONSTERS, iAttacker, ptr2)
			static pHit2; pHit2 = get_tr2(ptr2, TR_pHit)
			static iHitgroup2; iHitgroup2 = get_tr2(ptr2, TR_iHitgroup)
			
			// if ptr2 find target is iVictim
			if ( pHit2 == iVictim && (iHitgroup2 != HIT_HEAD || fDis <= fVicSize[0] * 0.25) )
			{
				pHit = iVictim
				iHitgroup = iHitgroup2
				get_tr2(ptr2, TR_vecEndPos, fEndPos)
			}
			
			free_tr2(ptr2)
		}
		
		// if pHit still not is iVictim then set default HitGroup
		if (pHit != iVictim)
		{
			// set default iHitgroup
			iHitgroup = HIT_GENERIC
			
			new ptr3 = create_tr2() 
			engfunc(EngFunc_TraceLine, fStart, fVicOrigin, DONT_IGNORE_MONSTERS, iAttacker, ptr3)
			get_tr2(ptr3, TR_vecEndPos, fEndPos)
			
			// free ptr3
			free_tr2(ptr3)
		}
	}
	
	// set new Hit & Hitgroup & EndPos
	set_tr2(ptr, TR_pHit, iVictim)
	set_tr2(ptr, TR_iHitgroup, iHitgroup)
	set_tr2(ptr, TR_vecEndPos, fEndPos)
	
	// hitgroup multi fDamage
	static Float:fMultifDamage 
	switch(iHitgroup)
	{
		case HIT_HEAD: fMultifDamage  = 4.0
		case HIT_STOMACH: fMultifDamage  = 1.25
		case HIT_LEFTLEG: fMultifDamage  = 0.75
		case HIT_RIGHTLEG: fMultifDamage  = 0.75
		default: fMultifDamage  = 1.0
	}
	
	fDamage *= fMultifDamage
	
	// ExecuteHam
	fake_trake_attack(iAttacker, iVictim, fDamage, fDirection, ptr)
	
	// free ptr
	free_tr2(ptr)
}

stock fake_trake_attack(iAttacker, iVictim, Float:fDamage, Float:fDirection[3], iTraceHandle, iDamageBit = (DMG_NEVERGIB | DMG_BULLET))
{
	ExecuteHam(Ham_TraceAttack, iVictim, iAttacker, fDamage, fDirection, iTraceHandle, iDamageBit)
}

stock fake_take_damage(iAttacker, iVictim, Float:fDamage, iInflictor = 0, iDamageBit = (DMG_NEVERGIB | DMG_BULLET))
{
	ExecuteHam(Ham_TakeDamage, iVictim, iInflictor, iAttacker, fDamage, iDamageBit)
}

stock get_angle_to_target(id, const Float:fTarget[3], Float:TargetSize = 0.0)
{
	new Float:fOrigin[3], iAimOrigin[3], Float:fAimOrigin[3], Float:fV1[3]
	pev(id, pev_origin, fOrigin)
	get_user_origin(id, iAimOrigin, 3) // end position from eyes
	IVecFVec(iAimOrigin, fAimOrigin)
	xs_vec_sub(fAimOrigin, fOrigin, fV1)
	
	new Float:fV2[3]
	xs_vec_sub(fTarget, fOrigin, fV2)
	
	new iResult = get_angle_between_vectors(fV1, fV2)
	
	if (TargetSize > 0.0)
	{
		new Float:fTan = TargetSize / get_distance_f(fOrigin, fTarget)
		new fAngleToTargetSize = floatround( floatatan(fTan, degrees) )
		iResult -= (iResult > 0) ? fAngleToTargetSize : -fAngleToTargetSize
	}
	
	return iResult
}

stock get_angle_between_vectors(const Float:fV1[3], const Float:fV2[3])
{
	new Float:fA1[3], Float:fA2[3]
	engfunc(EngFunc_VecToAngles, fV1, fA1)
	engfunc(EngFunc_VecToAngles, fV2, fA2)
	
	new iResult = floatround(fA1[1] - fA2[1])
	iResult = iResult % 360
	iResult = (iResult > 180) ? (iResult - 360) : iResult
	
	return iResult
}

stock Vector_To_Velocity(id, Trace_Result, Float:Speed, Float:RetVel[3])
{
	static Float:vecSrc[3], Float:vecEnd[3], Float:vecEnd2[3]
	
	get_weapon_attachment(id, vecSrc)
	global_get(glb_v_forward, vecEnd)
	global_get(glb_v_forward, vecEnd2)
    
	xs_vec_mul_scalar(vecEnd, 8192.0, vecEnd)
	xs_vec_mul_scalar(vecEnd2, 8192.0, vecEnd2)
	xs_vec_add(vecSrc, vecEnd, vecEnd)
	xs_vec_add(vecSrc, vecEnd2, vecEnd2)
	
	get_tr2(Trace_Result, TR_vecEndPos, vecSrc)
	get_tr2(Trace_Result, TR_vecPlaneNormal, vecEnd)
	get_tr2(Trace_Result, TR_vecPlaneNormal, vecEnd2)
    
	xs_vec_mul_scalar(vecEnd, 2.5, vecEnd)
	xs_vec_mul_scalar(vecEnd2, 5.0, vecEnd2)
	xs_vec_add(vecSrc, vecEnd, vecEnd)
	xs_vec_add(vecSrc, vecEnd2, vecEnd2)
	
	get_speed_vector(vecEnd, vecEnd2, Speed, RetVel)
}

stock get_weapon_attachment(id, Float:output[3], Float:fDis = 40.0)
{ 
	static Float:vfEnd[3], viEnd[3] 
	get_user_origin(id, viEnd, 3)  
	IVecFVec(viEnd, vfEnd) 
	
	static Float:fOrigin[3], Float:fAngle[3]
	
	pev(id, pev_origin, fOrigin) 
	pev(id, pev_view_ofs, fAngle)
	
	xs_vec_add(fOrigin, fAngle, fOrigin) 
	
	static Float:fAttack[3]
	
	xs_vec_sub(vfEnd, fOrigin, fAttack)
	xs_vec_sub(vfEnd, fOrigin, fAttack) 
	
	static Float:fRate
	
	fRate = fDis / vector_length(fAttack)
	xs_vec_mul_scalar(fAttack, fRate, fAttack)
	
	xs_vec_add(fOrigin, fAttack, output)
}

public FindClosetEnemy(ent, can_see)
{
	new Float:maxdistance = 4980.0
	new indexid = 0	
	new Float:current_dis = maxdistance

	for(new i = 1 ;i <= g_MaxPlayers; i++)
	{
		if(can_see)
		{
			if(is_user_alive(i) && can_see_fm(ent, i) && entity_range(ent, i) < current_dis)
			{
				current_dis = entity_range(ent, i)
				indexid = i
			}
		} else {
			if(is_user_alive(i) && entity_range(ent, i) < current_dis)
			{
				current_dis = entity_range(ent, i)
				indexid = i
			}			
		}
	}	
	
	return indexid
}


public bool:can_see_fm(entindex1, entindex2)
{
	if (!entindex1 || !entindex2)
		return false

	if (pev_valid(entindex1) && pev_valid(entindex1))
	{
		new flags = pev(entindex1, pev_flags)
		if (flags & EF_NODRAW || flags & FL_NOTARGET)
		{
			return false
		}

		new Float:lookerOrig[3]
		new Float:targetBaseOrig[3]
		new Float:targetOrig[3]
		new Float:temp[3]

		pev(entindex1, pev_origin, lookerOrig)
		pev(entindex1, pev_view_ofs, temp)
		lookerOrig[0] += temp[0]
		lookerOrig[1] += temp[1]
		lookerOrig[2] += temp[2]

		pev(entindex2, pev_origin, targetBaseOrig)
		pev(entindex2, pev_view_ofs, temp)
		targetOrig[0] = targetBaseOrig [0] + temp[0]
		targetOrig[1] = targetBaseOrig [1] + temp[1]
		targetOrig[2] = targetBaseOrig [2] + temp[2]

		engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, 0, entindex1, 0) //  checks the had of seen player
		if (get_tr2(0, TraceResult:TR_InOpen) && get_tr2(0, TraceResult:TR_InWater))
		{
			return false
		} 
		else 
		{
			new Float:flFraction
			get_tr2(0, TraceResult:TR_flFraction, flFraction)
			if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == entindex2))
			{
				return true
			}
			else
			{
				targetOrig[0] = targetBaseOrig [0]
				targetOrig[1] = targetBaseOrig [1]
				targetOrig[2] = targetBaseOrig [2]
				engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, 0, entindex1, 0) //  checks the body of seen player
				get_tr2(0, TraceResult:TR_flFraction, flFraction)
				if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == entindex2))
				{
					return true
				}
				else
				{
					targetOrig[0] = targetBaseOrig [0]
					targetOrig[1] = targetBaseOrig [1]
					targetOrig[2] = targetBaseOrig [2] - 17.0
					engfunc(EngFunc_TraceLine, lookerOrig, targetOrig, 0, entindex1, 0) //  checks the legs of seen player
					get_tr2(0, TraceResult:TR_flFraction, flFraction)
					if (flFraction == 1.0 || (get_tr2(0, TraceResult:TR_pHit) == entindex2))
					{
						return true
					}
				}
			}
		}
	}
	return false
}
